package gov.va.med.mhv.common.data.model;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;

@Entity
@Table(name = "PATIENT")
public class Patient extends AbstractBaseEntity {

	private static final long serialVersionUID = -2159151200516087122L;

	private static final Log log = LogFactory.getLog(Patient.class);

	@Id
	@Column(name = "PATIENT_ID")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long id;

	@Version
	@Column(name = "OPLOCK")
	private Integer oplock;

	@Column(name = "INVALIDATION_REFERENCE_ID")
	private String invalidationReferenceId;

	@Column(name = "LAST_FACILITIES_UPDATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date lastFacilitiesUpdateDateTime;

	@Column(name = "ICN")
	private String icn;

	@Column(name = "CORRELATION_ERROR_CODE")
	private String correlationErrorCode;

	@Column(name = "MATCHED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date matchedDateTime;

	@Column(name = "CORRELATE_REQUEST_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date correlateRequestDateTime;

	@Column(name = "INVALIDATED_ICN")
	private String invalidatedIcn;

	@Column(name = "CORRELATED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date correlatedDateTime;

	@Column(name = "CORRELATION_STATUS")
	private Integer correlationStatus;

	@Column(name = "CORRELATED_BY")
	private String correlatedBy;

	@OneToMany(mappedBy = "patient", fetch = FetchType.EAGER, cascade = CascadeType.ALL)
	@Fetch(FetchMode.SELECT)
	private Set<Facility> facilities;

	@OneToMany(mappedBy = "patient", fetch = FetchType.EAGER, cascade = CascadeType.ALL)
	@Fetch(FetchMode.SELECT)
	@NotFound(action=NotFoundAction.IGNORE)
	private Set<PatientRegistryChange> patientRegistryChanges;

	@OneToMany(mappedBy = "patient", fetch = FetchType.EAGER)
	@Fetch(FetchMode.SELECT)
	private Set<PatientSynchronization> patientSynchronizations;

	@OneToMany(mappedBy = "patient", fetch = FetchType.EAGER)
	@Fetch(FetchMode.SELECT)
	private Set<InPersonAuthentication> ipas;

	@Column(name = "USER_PROFILE_USER_PROFILE_ID", insertable = false, updatable = false)
	private Long userProfileId;

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "USER_PROFILE_USER_PROFILE_ID")
	private UserProfile userProfile;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public String getInvalidationReferenceId() {
		return invalidationReferenceId;
	}

	public void setInvalidationReferenceId(String invalidationReferenceId) {
		this.invalidationReferenceId = invalidationReferenceId;
	}

	public Date getLastFacilitiesUpdateDateTime() {
		return lastFacilitiesUpdateDateTime;
	}

	public void setLastFacilitiesUpdateDateTime(Date lastFacilitiesUpdateDateTime) {
		this.lastFacilitiesUpdateDateTime = lastFacilitiesUpdateDateTime;
	}

	public String getIcn() {
		return icn;
	}

	public void setIcn(String icn) {
		this.icn = icn;
	}

	public String getCorrelationErrorCode() {
		return correlationErrorCode;
	}

	public void setCorrelationErrorCode(String correlationErrorCode) {
		this.correlationErrorCode = correlationErrorCode;
	}

	public Date getMatchedDateTime() {
		return matchedDateTime;
	}

	public void setMatchedDateTime(Date matchedDateTime) {
		this.matchedDateTime = matchedDateTime;
	}

	public Date getCorrelateRequestDateTime() {
		return correlateRequestDateTime;
	}

	public void setCorrelateRequestDateTime(Date correlateRequestDateTime) {
		this.correlateRequestDateTime = correlateRequestDateTime;
	}

	public String getInvalidatedIcn() {
		return invalidatedIcn;
	}

	public void setInvalidatedIcn(String invalidatedIcn) {
		this.invalidatedIcn = invalidatedIcn;
	}

	public Date getCorrelatedDateTime() {
		return correlatedDateTime;
	}

	public void setCorrelatedDateTime(Date correlatedDateTime) {
		this.correlatedDateTime = correlatedDateTime;
	}

	public Integer getCorrelationStatus() {
		return correlationStatus;
	}

	public void setCorrelationStatus(Integer correlationStatus) {
		this.correlationStatus = correlationStatus;
	}

	public String getCorrelatedBy() {
		return correlatedBy;
	}

	public void setCorrelatedBy(String correlatedBy) {
		this.correlatedBy = correlatedBy;
	}

	public Set<Facility> getFacilities() {
		return facilities;
	}

	public void setFacilities(Set<Facility> facilities) {
		this.facilities = facilities;
		
		if(facilities != null) {
			for(Facility patientFacility : facilities) {
				patientFacility.setPatient(this);
			}
		}
	}

	public Set<PatientRegistryChange> getPatientRegistryChanges() {
		//Jazz # 265098 - Unable to Register a New Account in MHV Liferay Systest Env
		if (patientRegistryChanges == null) {
			patientRegistryChanges = new HashSet<PatientRegistryChange>();
		}
		
		return patientRegistryChanges;
	}

	public void setPatientRegistryChanges(Set<PatientRegistryChange> patientRegistryChanges) {
		this.patientRegistryChanges = patientRegistryChanges;
	}

	public Set<PatientSynchronization> getPatientSynchronizations() {
		if (patientSynchronizations == null) {
			patientSynchronizations = new HashSet<PatientSynchronization>();
		}
		return patientSynchronizations;
	}

	public void setPatientSynchronizations(Set<PatientSynchronization> patientSynchronizations) {
		this.patientSynchronizations = patientSynchronizations;
	}

	public Long getUserProfileId() {
		return userProfileId;
	}

	public void setUserProfileId(Long userProfileId) {
		this.userProfileId = userProfileId;
	}

	public UserProfile getUserProfile() {
		return userProfile;
	}

	public void setUserProfile(UserProfile userProfile) {
		this.userProfile = userProfile;
	}

	public Set<InPersonAuthentication> getIpas() {
		return ipas;
	}

	public void setIpas(Set<InPersonAuthentication> ipas) {
		this.ipas = ipas;
	}

	public void addPatientRegistryChange(PatientRegistryChange patientRegistryChange) {
		if (null != patientRegistryChange) {
			if (getPatientRegistryChanges().contains(patientRegistryChange)) {
				getPatientRegistryChanges().remove(patientRegistryChange);
			}
			patientRegistryChange.setPatient(this);
			getPatientRegistryChanges().add(patientRegistryChange);
		} else {
			log.debug("patientRegistryChange is null");
		}

	}

	/**
	 * Add a patientSynchronization
	 *
	 * @param The
	 *            patientSynchronization to add
	 */
	public void addPatientSynchronization(PatientSynchronization patientSynchronization) {
		if (getPatientSynchronizations().contains(patientSynchronization)) {
			getPatientSynchronizations().remove(patientSynchronization);
		}
		patientSynchronization.setPatient(this);
		getPatientSynchronizations().add(patientSynchronization);
	}

	/**
	 * Remove a patientSynchronization
	 *
	 * @param The
	 *            patientSynchronization to remove
	 */
	public PatientSynchronization removePatientSynchronization(PatientSynchronization patientSynchronization) {
		if (getPatientSynchronizations().remove(patientSynchronization)) {
			patientSynchronization.setPatient(null);
		}

		return patientSynchronization;
	}

}
